/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.ui.element;

import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.ui.element.AbstractElement;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class HorizontalElement {
    final AbstractElement[] elements;
    final int height;

    public HorizontalElement(AbstractElement ... elements) {
        this.elements = elements;
        this.height = this.calculateHeight(elements);
    }

    public int draw(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull BlitCoordinates availableArea, int mouseX, int mouseY, boolean mouseDown) {
        availableArea = availableArea.withHeight(this.height);
        int widthPerElement = availableArea.getWidth() / this.elements.length;
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].draw(instance, graphics, availableArea.move(widthPerElement * i, 0).withWidth(widthPerElement).withHeight(this.height).toRect(), mouseX, mouseY, mouseDown);
        }
        return this.height;
    }

    public int drawDebug(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull BlitCoordinates availableArea, int index) {
        availableArea = availableArea.withHeight(this.height);
        int widthPerElement = availableArea.getWidth() / this.elements.length;
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].drawDebug(instance, graphics, availableArea.move(widthPerElement * i, 0).withWidth(widthPerElement).withHeight(this.height).toRect(), i);
        }
        return this.height;
    }

    public int calculateHeight(AbstractElement[] elements) {
        int maxHeight = 0;
        for (AbstractElement element : elements) {
            int height = element.getFixedHeight();
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        return maxHeight;
    }
}

